﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VA.TMP.Integration.VIMT.Vista.Links;

namespace VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient
{
    public class CreateResponseStep : FilterBase<GetConsultsForPatientStateObject>
    {
        public override void Execute(GetConsultsForPatientStateObject state)
        {
            GetConsultsforPatientMapper mapper = new GetConsultsforPatientMapper();
            if (!string.IsNullOrEmpty(state.ConsultsFakeResponseType))
            {
                //TODO move this fakeEcResponse into the SendToEc pipeline step and put the value into the state object into the same attribute that the real Ec Responses are going
                var fakeEcResponse = VistaFakeResponses.FakeGetConsultsForPatientSuccess();
                state.GetConsultsResponse = new GetConsultsForPatientResponse
                {
                    ExceptionMessage = "*****THIS IS FAKE DATA. DATA NOT SENT TO VISTA*****",
                    ExceptionOccured = false,
                    SerializedInstance = string.Empty,
                    ProGetConsultsForPatientRespTaggedConsultArraysInfo = mapper.MapEcToLob(fakeEcResponse),
                    PatGetConsultsForPatientRespTaggedConsultArraysInfo = mapper.MapEcToLob(fakeEcResponse)
                };
            }
            else
            {
                state.GetConsultsResponse = state.ExceptionOccured
                    ? new GetConsultsForPatientResponse
                    {
                        ExceptionOccured = true,
                        ExceptionMessage = state.ExceptionMessage,
                        
                    }
                    : new GetConsultsForPatientResponse
                    {
                        ExceptionMessage = string.Empty,
                        ExceptionOccured = false,
                        ProGetConsultsForPatientRespTaggedConsultArraysInfo = mapper.MapEcToLob(state.ProEcResponse),
                        PatGetConsultsForPatientRespTaggedConsultArraysInfo = mapper.MapEcToLob(state.PatEcResponse)
                    };
            }
        }
    }
}
